// PCTPServer.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <conio.h>

#include "PCAN-ISO-TP.h"

#define USE_CAN_FD false
#define USE_EVENT false

#define N_SA		((BYTE)0xF1)
#define N_TA_PHYS	((BYTE)0x13)
#define N_TA_FUNC	((BYTE)0x26)
#define N_RA		((BYTE)0x52)

/// <summary>Main entry-point for this application.</summary>
/// <param name="argc">The argc.</param>
/// <param name="argv">[in,out] If non-null, the argv.</param>
/// <returns>Exit status</returns>
int main(int argc, char* argv[])
{
	TPCANTPStatus Status;
	TPCANTPHandle Channel;
	WORD usValue;
	char buffer[500];
	BYTE param;
	int nbErr = 0;	
	bool useCanFd;
	bool useEvent;
	bool bStop = false;
	TPCANTPBaudrate baudrate;
	TPCANTPBitrateFD bitrateFd;
	HANDLE eventRcv = NULL;

	printf("\nUsage: PCTPServer.exe [TPCANTPHandle] [USE_CAN_FD:0|1] [BTR0BTR1|BITRATE]\n");
	printf(" * CAN: PCTPServer.exe 0x51 0 0x1C \n");
	printf(" * CAN FD: PCTPServer.exe 0x51 1 \"f_clock=80000000, nom_brp=10, nom_tseg1=12, nom_tseg2=3, nom_sjw=1, data_brp=4, data_tseg1=7, data_tseg2=2, data_sjw=1\" \n");
	printf("\n---------------------------------------------\n");

	printf("\nNote: press 'c' or 'C' to clear screen,");
	printf("\nNote: press 'q', 'Q' or '<Escape>' to quit...\n");
	printf("\n---------------------------------------------\n\n");

	// Show version information
	CANTP_GetValue(0, PCANTP_PARAM_API_VERSION, &buffer, 500);
	printf("PCAN-ISO-TP API Version : %s\n", buffer);
	
	// 1st argument is the PCAN-Channel to use (PCAN-USB Channel 2)
	if (argc > 1)
		Channel = (TPCANTPHandle)strtol(argv[1], NULL, 0);
	else
		Channel = PCANTP_USBBUS2;
	// 2nd argument is CAN FD
	if (argc > 2)
		useCanFd = strtol(argv[2], NULL, 0) == 1;
	else
		useCanFd = USE_CAN_FD;
	// 3rd argument is bitrate (either CAN or CAN FD)
	baudrate = PCANTP_BAUD_500K;
	bitrateFd = "f_clock=80000000, nom_brp=10, nom_tseg1=12, nom_tseg2=3, nom_sjw=1, data_brp=4, data_tseg1=7, data_tseg2=2, data_sjw=1";
	if (argc > 3) {
		if (useCanFd)
			bitrateFd = argv[3];
		else 
			baudrate = (TPCANTPBaudrate)strtoul(argv[3], NULL, 0);
	}
	// 4th argument is USE EVENT
	if (argc > 4)
		useEvent = strtol(argv[4], NULL, 0) == 1;
	else
		useEvent = USE_EVENT;

	// Initializing of the ISO-TP Communication session
	printf("Connecting to channel 0x%02x...\n", Channel);
	if (!useCanFd) {
		printf(" * btr0btr1 = 0x%02x...\n", baudrate);
		Status = CANTP_Initialize(Channel, baudrate, 0, 0, 0);
	}
	else {
		printf(" * bitrateFd = \"%s\"...\n", bitrateFd);
		Status = CANTP_InitializeFD(Channel, bitrateFd);
	}
	printf(" -> Initialize CANTP: %x\n", (int)Status);
	// will start the reading loop only if successfully initialized
	if (Status != PCANTP_ERROR_OK) {
		bStop = true;		
		nbErr++;
		printf(" -> Initialization failed, exiting...\n");
	}

	// configure the test session to show all transmitted CAN messages
	usValue = PCANTP_DEBUG_NONE; //PCANTP_DEBUG_CAN;
	CANTP_SetValue(Channel,PCANTP_PARAM_DEBUG, &usValue, 1);
	// configure server parameters
	param = PCANTP_MSG_PENDING_SHOW;	// show pending multi-frame messages
	Status = CANTP_SetValue(Channel,PCANTP_PARAM_MSG_PENDING, &param, 1);
	param = 20;		// block size, 0 = unlimited
	Status = CANTP_SetValue(Channel, PCANTP_PARAM_BLOCK_SIZE, &param, 1);
	param = 2;		// wait Xms between segmented frames transmission
	Status = CANTP_SetValue(Channel, PCANTP_PARAM_SEPARATION_TIME, &param, 1);
	// configure receive event
	if (useEvent) {
		eventRcv = CreateEvent(NULL, false, false, NULL);	
		Status = CANTP_SetValue(Channel, 0xEA, &eventRcv, sizeof(eventRcv));
	}

	// Configure Mapping
	// some transmissions require a Mapping between CAN ID and Netword Addressing Information
	// for each transmission, 3 mappings are added :
	//	- 2 for physical addressing, one defining SA->TA and the other TA->SA
	//	- 1 for functional addressing, one defining SA->TA
	//

	// 11 bit can ID, normal format addressing (diagnostic message mandatory)
	CANTP_AddMapping(Channel, 0xA1, 0xA2,
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_NORMAL, PCANTP_MESSAGE_DIAGNOSTIC,
		N_SA, N_TA_PHYS, PCANTP_ADDRESSING_PHYSICAL, 0x00);
	CANTP_AddMapping(Channel, 0xA2, 0xA1,
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_NORMAL, PCANTP_MESSAGE_DIAGNOSTIC,
		N_TA_PHYS, N_SA, PCANTP_ADDRESSING_PHYSICAL, 0x00);
	CANTP_AddMapping(Channel, 0xA5, CAN_ID_NO_MAPPING, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_NORMAL, PCANTP_MESSAGE_DIAGNOSTIC,
		N_SA, N_TA_FUNC, PCANTP_ADDRESSING_FUNCTIONAL, 0x00);
	// 11 bit can ID, extended format addressing, diagnostic message
	CANTP_AddMapping(Channel, 0xB1, 0xB2, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_DIAGNOSTIC,
		N_SA, N_TA_PHYS, PCANTP_ADDRESSING_PHYSICAL, 0x00);
	CANTP_AddMapping(Channel, 0xB2, 0xB1, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_DIAGNOSTIC,
		N_TA_PHYS, N_SA, PCANTP_ADDRESSING_PHYSICAL, 0x00);
	CANTP_AddMapping(Channel, 0xB5, CAN_ID_NO_MAPPING, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_DIAGNOSTIC,
		N_SA, N_TA_FUNC, PCANTP_ADDRESSING_FUNCTIONAL, 0x00);
	// 11 bit can ID, extended format addressing, remote diagnostic message
	CANTP_AddMapping(Channel, 0xC1, 0xC2, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		N_SA, N_TA_PHYS, PCANTP_ADDRESSING_PHYSICAL, N_RA);
	CANTP_AddMapping(Channel, 0xC2, 0xC1, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		N_TA_PHYS, N_SA, PCANTP_ADDRESSING_PHYSICAL, N_RA);
	CANTP_AddMapping(Channel, 0xC5, CAN_ID_NO_MAPPING, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		N_SA, N_TA_FUNC, PCANTP_ADDRESSING_FUNCTIONAL, N_RA);
	// 11 bit can ID, mixed format addressing (remote diagnostic message mandatory)
	CANTP_AddMapping(Channel, 0xD1, 0xD2, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_MIXED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		N_SA, N_TA_PHYS, PCANTP_ADDRESSING_PHYSICAL, N_RA);
	CANTP_AddMapping(Channel, 0xD2, 0xD1, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_MIXED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		N_TA_PHYS, N_SA, PCANTP_ADDRESSING_PHYSICAL, N_RA);
	CANTP_AddMapping(Channel, 0xD5, CAN_ID_NO_MAPPING, 
		PCANTP_ID_CAN_11BIT, PCANTP_FORMAT_MIXED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		N_SA, N_TA_FUNC, PCANTP_ADDRESSING_FUNCTIONAL, N_RA);
	// 29 bit can ID, normal format addressing (diagnostic message mandatory)
	CANTP_AddMapping(Channel, 0xA123A1, 0xA123A2, 
		PCANTP_ID_CAN_29BIT, PCANTP_FORMAT_NORMAL, PCANTP_MESSAGE_DIAGNOSTIC,
		N_SA, N_TA_PHYS, PCANTP_ADDRESSING_PHYSICAL, 0x00);
	CANTP_AddMapping(Channel, 0xA123A2, 0xA123A1, 
		PCANTP_ID_CAN_29BIT, PCANTP_FORMAT_NORMAL, PCANTP_MESSAGE_DIAGNOSTIC,
		N_TA_PHYS, N_SA, PCANTP_ADDRESSING_PHYSICAL, 0x00);
	CANTP_AddMapping(Channel, 0xA123A5, CAN_ID_NO_MAPPING, 
		PCANTP_ID_CAN_29BIT, PCANTP_FORMAT_NORMAL, PCANTP_MESSAGE_DIAGNOSTIC,
		N_SA, N_TA_FUNC, PCANTP_ADDRESSING_FUNCTIONAL, 0x00);
	// 29 bit can ID, extended format addressing, diagnostic message
	CANTP_AddMapping(Channel, 0xA123C1,  0xA123C2, 
		PCANTP_ID_CAN_29BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_DIAGNOSTIC,
		N_SA, N_TA_PHYS, PCANTP_ADDRESSING_PHYSICAL, 0x00);
	CANTP_AddMapping(Channel, 0xA123C2,  0xA123C1, 
		PCANTP_ID_CAN_29BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_DIAGNOSTIC,
		N_TA_PHYS, N_SA, PCANTP_ADDRESSING_PHYSICAL, 0x00);
	CANTP_AddMapping(Channel, 0xA123C5, CAN_ID_NO_MAPPING, 
		PCANTP_ID_CAN_29BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_DIAGNOSTIC,
		N_SA, N_TA_FUNC, PCANTP_ADDRESSING_FUNCTIONAL, 0x00);
	// 29 bit can ID, extended format addressing, remote diagnostic message
	CANTP_AddMapping(Channel, 0xA123D1, 0xA123D2, 
		PCANTP_ID_CAN_29BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		N_SA, N_TA_PHYS, PCANTP_ADDRESSING_PHYSICAL, N_RA);
	CANTP_AddMapping(Channel, 0xA123D2, 0xA123D1, 
		PCANTP_ID_CAN_29BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		N_TA_PHYS, N_SA, PCANTP_ADDRESSING_PHYSICAL, N_RA);
	CANTP_AddMapping(Channel, 0xA123D5, CAN_ID_NO_MAPPING, 
		PCANTP_ID_CAN_29BIT, PCANTP_FORMAT_EXTENDED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		N_SA, N_TA_FUNC, PCANTP_ADDRESSING_FUNCTIONAL, N_RA);

	// Reading loop
	TPCANTPMsg Message;
	DWORD result;
	while(!bStop)
	{
		if (useEvent)
			result = WaitForSingleObject(eventRcv, 1);
		else {
			Sleep(1);
			result = WAIT_OBJECT_0;
		}
		if (result == WAIT_OBJECT_0)
		{
			// loop until no more message is available
			do {
				Status = CANTP_Read(Channel, &Message);
				if (Status == PCANTP_ERROR_OK) {
					switch (Message.MSGTYPE)
					{
					case PCANTP_MESSAGE_REQUEST_CONFIRMATION:
						printf("\nReceived confirmation from 0x%02x (to 0x%02x, with RA 0x%02x) - result: %i - %s\n",
							(int)Message.SA,
							(int)Message.TA,
							(int)Message.RA,
							(int)Message.RESULT,
							Message.RESULT != PCANTP_N_OK ? "ERROR !!!" : "OK !");
						// display data
						setvbuf(stdout, buffer, _IOLBF, BUFSIZ);
						printf("\t\\-> Length: %i, Data= ", (int)Message.LEN);
						for (int i = 0; i < Message.LEN; i++) {
							printf("%02x ", (int)Message.DATA[i]);
							fflush(stdout);
						}
						printf("\n");
						setvbuf(stdout, NULL, _IONBF, 0);
						break;
					case PCANTP_MESSAGE_INDICATION:
					case PCANTP_MESSAGE_INDICATION_TX:
						printf("\n/!\\ Message pending from 0x%02x (to 0x%02x, with RA 0x%02x) LEN=%i - result: %i...\n",
							(int)Message.SA,
							(int)Message.TA,
							(int)Message.RA,
							(int)Message.LEN,
							(int)Message.RESULT);

						// display data
						setvbuf(stdout, buffer, _IOLBF, BUFSIZ);
						printf("\t\\-> Data Abstract (FirstFrame) = ");
						for (int i = 0; i < 10; i++) {
							printf("%02x ", (int)Message.DATA[i]);
							fflush(stdout);
						}
						printf("...\n");
						setvbuf(stdout, NULL, _IONBF, 0);
						break;
					default:
						printf("\nReceived message from 0x%02x (to 0x%02x, with RA 0x%02x) - result: %i - %s\n",
							(int)Message.SA,
							(int)Message.TA,
							(int)Message.RA,
							(int)Message.RESULT,
							Message.RESULT != PCANTP_N_OK ? "ERROR !!!" : "OK !");
						if (Message.RESULT == PCANTP_N_OK)
						{
							// display data
							setvbuf(stdout, buffer, _IOLBF, BUFSIZ);
							printf("\t\\-> Length: %i, Data= ", (int)Message.LEN);
							for (int i = 0; i < Message.LEN; i++) {
								printf("%02x ", (int)Message.DATA[i]);
								fflush(stdout);
							}
							printf("\n");
							setvbuf(stdout, NULL, _IONBF, 0);
						}
						else {
							printf("\t\\-> Unexpected error, Length: %i\n\n", (int)Message.LEN);
						}
						break;
					}
					if (Message.RESULT != PCANTP_N_OK)
						nbErr++;
				}
			} while (Status != PCANTP_ERROR_NO_MESSAGE);
		}
		//Sleep(1);		
		// check exit request
		if (_kbhit()) {
			switch(_getch()) {
				case 'q':
				case 'Q':
				case 27:	//Escape
					bStop = true;
					break;
				case 0x08:	// backspace
					CANTP_Reset(Channel);
					// no break do clear...
				case 'c':
				case 'C':					
					system("cls");
					printf("\nNote: press 'c' or 'C' to clear screen,");
					printf("\nNote: press 'q', 'Q' or '<Escape>' to quit...\n\n");
					break;
			}
		}
	}
	
	// Display a small report
	if (nbErr > 0) {
		printf("\nERROR : %d errors occured.\n\n", nbErr);		
	} 
	else {		
		printf("\nALL Transmissions succeeded !\n\n");
	}
	printf("\n\nPress <Enter> to quit...");
	getchar();

	// release CAN-TP
	CANTP_Uninitialize(Channel);
	return 0;
}

